	function PLOT_MAG_PHASE_S(Mag, Phase, W, axis_Amax)

	%	Plots the magnitude and phase for an analog filter in a single figure
 
	% Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2007-09-13
	% Modified by: 	 	LW 2011-01-23 
	% Copyright:		by authors - not released for commercial use
	% Version:			1  
	% Known bugs:		Plots on the wrong axis
	% Report bugs to:	lars.wanhammar@liu.se
	%
	%========================================================	
	% Standard settings
	fs = 16; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	 
	%========================================================	
	subplot('position', [0.1 0.4 0.84 0.5]);
	M = length(W);
	for n = 1:M
		if Phase(n) < -pi
			for m = n:M
				Phase(m) = Phase(m)+2*pi;
			end
		end
		if Phase(n) > pi
			for m = n:M
				Phase(m) = Phase(m)-2*pi;
			end
		end
	end

	[AX, H1, H2] = plotyy(W, Mag, W, Phase);

	set(H1, 'linewidth', lw);
	set(H2, 'linewidth', lw);
	axis_Amin = floor(min(Mag)/10)*10-10;
	set(AX(1), 'ylim', [axis_Amin axis_Amax+1]);
	set(AX(1), 'ytick', [axis_Amin:10: axis_Amax+1]);
	set(AX(2), 'ylim', [-pi pi]);
%	set(AX(2), 'ytick', [-pi:0.2*pi:pi]);
%set(AX(2), 'ytick', []);

	grid on;
	hold on;
	set(gca,'FontName', fn,'FontSize', fs);
	ylabel('|{\itH}({\itj\omega})|  [dB]','FontName',fn,'FontSize',fs);	
	xlabel('{\it\omega}  [rad/s]','FontName', fn,'FontSize',fs);
	axes(AX(2))	
	ylabel('{\it\Phi}({\it\omega}) [rad]','FontName', fn,'FontSize',fs) ; 
	ay = [-pi -0.75*pi -0.5*pi -0.25*pi 0 0.25*pi 0.5*pi 0.75*pi pi];
	laby = {'-\pi';'-0.75\pi';'-0.5\pi';' ';' ';' ';'0.5\pi';'0.75\pi';'\pi'};
	ytick(ay,laby);	

 
